from .paths import FluidLabPaths
import re
from os.path import join
from typing import Union


def read_addon_version() -> Union[str, None]:

    addon_folder = FluidLabPaths.ROOT
    main_addon_file = join(addon_folder, "__init__.py")

    main_file = open(main_addon_file, "r", encoding='UTF-8')
    lines = main_file.readlines()

    version = None
    for line in lines:
        match = re.search("^\s*[\"|\']version[\"|\']:\s?\((.*)\).*$", line)
        if match:
            version = match.group(1).replace(" ", "").replace(",", ".")
            break

    return version
